<?LassoScript
/*
<fusedoc fuse="fbx_Settings.inc" language="Lasso" specification="3.0">
	<responsibilities>
		I set up the enviroment settings for this circuit. If this settings file is being inherited, then you can use VARIABLE to override
		a value set in a parent circuit or FBX_PARAM to accept a value set by a parent circuit
	</responsibilities>	
	<properties>
		<history author="Rich Tretola" email="rich@lassofusebox.org" date="10/07/2002" type="Create">
		<history author="Tami Williams" date="May 2003" email="tami@asktami.com" type="Update" />
		<history author="Tami Williams" date="05/23/08" email="tami@asktami.com" type="Update" />
	</properties>
	<io>
		<in>
			<structure name="fusebox">
				<boolean name="isRootCircuit" comments="Is the circuit currently executing the root circuit?" />
			</structure>
		</in>
		<out>
			<string name="frame" scope="variables" />
			<string name="fuseaction" scope="variables" />
			<string name="targetContent" scope="variables" />
			<string name="nav" scope="variables" />
			<string name="XFA_Homer" scope="variables" />
			<string name="XFA_Marge" scope="variables" />
			<string name="XFA_Bart" scope="variables" />
			<string name="XFA_Maggie" scope="variables" />
			<string name="XFA_Lisa" scope="variables" />
			<string name="XFA_MaggieALT" scope="variables" />
		</out>
	</io>
</fusedoc>
*/


//default frame variable
FBX_Param: -Name='frame', -Default='N' ;


// default fuseaction MUST be in this file

if: $frame == 'Y';
	FBX_Param: -Name='fuseaction', -Default='simpsonfamily.frameset' ;
	FBX_Param: -Name='targetContent', -Default='TARGET=\"content\"' ;
else;	
	FBX_Param: -Name='fuseaction', -Default='simpsonfamily.main' ;
	FBX_Param: -Name='targetContent', -Default='' ;
/if;

var: 'img' =  'images/';


var: 'self' = 'index.lasso?frame=' + $frame + '&fuseaction=' ;

// the circuit alias for the FRAMES folder is hardcoded after the = sign below so that the FrameSet page (Frames/dsp_frameset.inc) will work correctly
var:'selfFrameSet' = 'index.lasso?frame=' + $frame + '&fuseaction=simpsonfamily.' ;
 
 
var: 'selfFrameN' = 'index.lasso?frame=N' ,
'selfFrameY' = 'index.lasso?frame=Y' ;

// used by _lay/lay_noframes.lasso
var: 'header' = 'FRAMES/dsp_frmheader.inc' ;

// used by FRAMES/dsp_frmnav.inc AND _lay/lay_noframes.lasso

if: $frame == 'Y';
	var: 'nav' = 'dsp_nav.inc' ;
else;
	var: 'nav' = 'FRAMES/dsp_nav.inc' ;
/if;


var: 'XFA_Grandpa' = $self + 'Grandpa.main',
'XFA_Homer' = $self + 'Homer.main',
'XFA_Marge' = $self + 'Marge.main',
'XFA_Bart' = $self + 'Bart.main',
'XFA_Lisa' = $self + 'Lisa.main',
'XFA_Maggie' = $self + 'Maggie.main',
'XFA_MaggieALT' = $self + 'Maggie.main&stopLayout=Y';

?>